<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 04.12.13 10:15
 */

namespace VM\PackageGeneratorBundle\Services;


use VM\PackageGeneratorBundle\Exceptions\CutterException;

class PDFCutter
{

    public function cutPdf($path, $dir)
    {
        try
        {
            $this->fileExists($path);
            $this->createDestinationDir($dir);
            $this->cut($path, $dir);
        }
        catch(\Exception $Exception)
        {
            throw new CutterException($Exception->getMessage(), $Exception->getCode());
        }
    }


    /**
     * @param $path
     * @throws \Exception
     */
    protected function fileExists($path)
    {
        if(!file_exists($path))
        {
            throw new \Exception('File ' . $path . ' not exists');
        }
    }


    /**
     * @param $dir
     * @return bool
     */
    protected function createDestinationDir($dir)
    {
        if(!is_dir($dir .'/swf'))
        {
            mkdir($dir . '/swf', 0777, true);
        }

        if(!is_dir($dir .'/jpg'))
        {
            mkdir($dir . '/jpg', 0777, true);
        }

        return true;
    }


    protected function cut($path, $dir)
    {
        @system('/usr/local/bin/pdf2swf -qq -T 10 -f ' . $path . ' -o ' . $dir . '/swf/page_%.swf' );
        @system('/usr/local/bin/gs -dQUIET -dNOPAUSE -dBATCH -sDEVICE=jpeg -dTextAlphaBits=4 -dGraphicsAlphaBits=4 -r300 -sOutputFile=' . $dir . '/jpg/page_%d.jpg ' . $path . ' -c quit');
    }
} 